% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoC.fun.R
\name{RoC.fun}
\alias{RoC.fun}
\title{Calculates Rate of Change in simulated variables.}
\usage{
RoC.fun(results, field.list = NULL, type = "a")
}
\arguments{
\item{results}{Data table resembling the first element ("full") of the output from one of the archSeries simulation functions.}

\item{field.list}{Character vector of columns for which RoC should be calculated. Defaults to NULL, in which case all
suitable columns are used.}

\item{type}{Character: "a" for absolute change between bins; "r" for rate as a proportion of current value. Defaults to "a".}
}
\value{
The input data table with the addition of one new RoC column for each original value column.
}
\description{
Takes the standard "full" output from one of the archSeries simulation functions and adds columns giving rates of change between
     bins, for all value columns or a specified subset. Called within simulation functions by setting their 'RoC' arguments to
     TRUE, but can also be called directly after the fact.
}
\examples{
date.ranges <- data.table(ID=c(1, 2, 3, 4), Start=c(450, 450, 600, 900), End=c(700, 800, 650, 1200))
results <- date.simulate(date.ranges, start.date=400, end.date=1200, bin.width=200)
x <- RoC.fun(results[[1]])
}

